#! /bin/sh

# create the test data files
for i in 01 02 03 04 05 06 07 08 09 10 11 12 13 14 15;
do
   echo "Creating test file file$i.mnc"
   grep -v \# data.ascii |\
      head -$i | tail -1 |\
      cut -f4,6,8,10 -d\  |\
      perl -n -e 'print STDOUT pack("f4", split(/\ /, $_));' |\
      rawtominc -clobber -float \
         -xstep 1 -ystep 1 -xstart -1 -ystart -1 \
         file$i.mnc 2 2
done

# now run the PLS itself
../mincPLS -double design_matrix.dm -clobber out


